NIPING - Standalone Handler Utility
======================================================================

OVERVIEW
------------------------------
This standalone utility makes use of user-provided NIPING utilities to ping a list of SAP hosts and send the results to one or more Dynatrace environments via API.

* Author - SoftwareONE
* Version - 1.2.0
* Build - 3

Use of this software is governed by SoftwareONE's PowerConnect End User License Agreement.

INSTALLATION
------------------------------
* Prerequisites
    * A separate host system running Windows or Linux on the same network as your SAP deployment(s)
    * Python 3.6+ with the httplib2 library installed (embedded in this deployment)

* Installation
    1. Download this utility.
    2. Extract the utility in the desired folder.
    3. Find the niping utility executable for your host's operating system in an SAP install directory (for example: "...\usr\sap\SID\D123\exe").
    4. Copy the niping utility and associated library files to the utility's "/lib/niping" directory.
    5. Ensure that the host user has execute permissions for this directory:
        * On Linux, you may need to run the command "chmod -R +x niping_directory".
        * Windows permisions are managed via the Properties menu for the directory.
    6. Configure the target_hosts.ini file using the instructions provided within the file. You will need the following for each target SAP host:
        * SID
        * Host IP address
        * Port - Use 3200 as the default unless directed to use a different port by your BASIS team.
    7. Configure the target_endpoints.ini file using the instructions provided within the file. You will need the following for each Dynatrace tenant:
        * URI - The base tenant address; all API-specific add-ons for the address are done in the utility.
        * Token - Create an API token with logs ingest and metrics ingest permissions.
    8. Schedule the script to run at desired intervals in the host system; five minutes is a recommended starting point, but it can be run as frequently as every 30 seconds.
        * On Linux, use the crontab utility.
        * On Windows, use the Task Scheduler utility.

* Common Issues
    * Linux returns code 127
        * See that the correct executable for your operating system has been installed in the niping utility directory (see step four above).
    * Linux returns code 126
        * Ensure that the user has permissions to execute the installed niping program file (see step five above)

DEPENDENCIES
------------------------------
* Python 3.6+
* httplib2 v0.22.0 (embedded) - MIT License (see below)

Copyright 2006, Joe Gregorio

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.